<?php
session_start();

class AuthMiddleware {
    public static function isAuthenticated() {
        if (!isset($_SESSION['admin_id'])) {
            http_response_code(401);
            echo json_encode(array(
                "status" => "error",
                "message" => "Unauthorized access"
            ));
            exit();
        }
        return true;
    }

    public static function validateLoginInput($data) {
        $errors = array();
        
        if (empty($data->username)) {
            $errors[] = "Username is required";
        }
        if (empty($data->password)) {
            $errors[] = "Password is required";
        }
        
        return $errors;
    }

    public static function sanitizeInput($input) {
        return htmlspecialchars(strip_tags($input));
    }
}
?> 