<?php
// Required headers
header("Access-Control-Allow-Origin: *");
header("Content-Type: application/json; charset=UTF-8");
header("Access-Control-Allow-Methods: GET");
header("Access-Control-Max-Age: 3600");
header("Access-Control-Allow-Headers: Content-Type, Access-Control-Allow-Headers, Authorization, X-Requested-With");

// Include database and shipment model
include_once '../../config/db.php';
include_once '../../models/Shipment.php';

// Get tracking number
$tracking_number = isset($_GET['tn']) ? $_GET['tn'] : '';

// Validate tracking number
if (empty($tracking_number)) {
    http_response_code(400);
    echo json_encode(array(
        "status" => "error",
        "message" => "Tracking number is required"
    ));
    exit();
}

// Basic tracking number format validation (adjust pattern based on your format)
if (!preg_match("/^TRK\d{14}[A-Z0-9]{4}$/", $tracking_number)) {
    http_response_code(400);
    echo json_encode(array(
        "status" => "error",
        "message" => "Invalid tracking number format"
    ));
    exit();
}

try {
    // Get database connection
    $database = new Database();
    $db = $database->getConnection();

    // Create shipment instance
    $shipment = new Shipment($db);
    
    // Get shipment details
    $result = $shipment->getByTrackingNumber($tracking_number);

    if ($result) {
        // Add barcode URL to the response
        $result['barcode_url'] = "/api/public/barcode.php?data=" . urlencode($tracking_number);
        
        http_response_code(200);
        echo json_encode(array(
            "status" => "success",
            "data" => $result
        ));
    } else {
        http_response_code(404);
        echo json_encode(array(
            "status" => "error",
            "message" => "Shipment not found"
        ));
    }

} catch (Exception $e) {
    http_response_code(500);
    echo json_encode(array(
        "status" => "error",
        "message" => "Unable to track shipment",
        "error" => $e->getMessage()
    ));
}
?> 