<?php
// Include the barcode generator
require_once '../../includes/BarcodeGenerator.php';

// Get tracking number
$tracking_number = isset($_GET['data']) ? $_GET['data'] : '';

// Get optional parameters with defaults
$height = isset($_GET['height']) ? (int)$_GET['height'] : 100;
$width_factor = isset($_GET['width']) ? (int)$_GET['width'] : 2;

// Validate tracking number
if (empty($tracking_number)) {
    header('Content-Type: image/png');
    $img = imagecreate(400, 50);
    $bg = imagecolorallocate($img, 255, 255, 255);
    $textcolor = imagecolorallocate($img, 255, 0, 0);
    imagestring($img, 5, 10, 20, "Tracking number is required", $textcolor);
    imagepng($img);
    imagedestroy($img);
    exit();
}

// Basic tracking number format validation
if (!preg_match("/^TRK\d{14}[A-Z0-9]{4}$/", $tracking_number)) {
    header('Content-Type: image/png');
    $img = imagecreate(400, 50);
    $bg = imagecolorallocate($img, 255, 255, 255);
    $textcolor = imagecolorallocate($img, 255, 0, 0);
    imagestring($img, 5, 10, 20, "Invalid tracking number format", $textcolor);
    imagepng($img);
    imagedestroy($img);
    exit();
}

// Validate dimensions
if ($height < 50 || $height > 200) $height = 100;
if ($width_factor < 1 || $width_factor > 4) $width_factor = 2;

try {
    // Create barcode generator instance
    $generator = new BarcodeGenerator();
    
    // Output the barcode
    $generator->outputBarcode($tracking_number, $height, $width_factor);

} catch (Exception $e) {
    header('Content-Type: image/png');
    $img = imagecreate(400, 50);
    $bg = imagecolorallocate($img, 255, 255, 255);
    $textcolor = imagecolorallocate($img, 255, 0, 0);
    imagestring($img, 5, 10, 20, "Error generating barcode", $textcolor);
    imagepng($img);
    imagedestroy($img);
}
?> 