<?php
class Database {
    private $conn = null;

    public function __construct() {
        try {
            // Load config
            $config = require __DIR__ . '/config.php';
            
            if (!isset($config['db'])) {
                throw new Exception('Database configuration not found');
            }

            $db = $config['db'];
            
            // Create connection
            $this->conn = new PDO(
                "mysql:host={$db['host']};dbname={$db['name']};charset=utf8mb4",
                $db['user'],
                $db['pass'],
                [
                    PDO::ATTR_ERRMODE => PDO::ERRMODE_EXCEPTION,
                    PDO::ATTR_DEFAULT_FETCH_MODE => PDO::FETCH_ASSOC,
                    PDO::ATTR_EMULATE_PREPARES => false
                ]
            );
        } catch (PDOException $e) {
            error_log("Database connection error: " . $e->getMessage());
            throw new Exception('Database connection failed. Please check your database configuration and ensure MySQL is running.');
        } catch (Exception $e) {
            error_log("Configuration error: " . $e->getMessage());
            throw new Exception('Database configuration error. Please check your config.php file.');
        }
    }

    public function getConnection() {
        if (!$this->conn) {
            throw new Exception('Database connection is not established');
        }
        return $this->conn;
    }
} 