<?php
session_start();

function isAdminAuthenticated() {
    return isset($_SESSION['admin_id']) && !empty($_SESSION['admin_id']);
}

function isSuperAdmin() {
    return isset($_SESSION['admin_role']) && $_SESSION['admin_role'] === 'super_admin';
}

function getAdminId() {
    return $_SESSION['admin_id'] ?? null;
}

function getAdminUsername() {
    return $_SESSION['admin_username'] ?? null;
}

function getAdminRole() {
    return $_SESSION['admin_role'] ?? null;
}

function requireAdminAuth() {
    if (!isAdminAuthenticated()) {
        http_response_code(401);
        echo json_encode([
            'status' => 'error',
            'message' => 'Unauthorized access'
        ]);
        exit;
    }
}

function requireSuperAdmin() {
    requireAdminAuth();
    if (!isSuperAdmin()) {
        http_response_code(403);
        echo json_encode([
            'status' => 'error',
            'message' => 'Access forbidden. Super admin privileges required.'
        ]);
        exit;
    }
} 