<?php
// Required headers
header("Access-Control-Allow-Origin: *");
header("Content-Type: application/json; charset=UTF-8");
header("Access-Control-Allow-Methods: GET");
header("Access-Control-Max-Age: 3600");
header("Access-Control-Allow-Headers: Content-Type, Access-Control-Allow-Headers, Authorization, X-Requested-With");

// Include database, auth middleware and shipment model
include_once '../../../config/db.php';
include_once '../../../includes/auth_middleware.php';
include_once '../../../models/Shipment.php';

// Check authentication
AuthMiddleware::isAuthenticated();

// Get database connection
$database = new Database();
$db = $database->getConnection();

// Get shipment ID
$id = isset($_GET['id']) ? (int)$_GET['id'] : 0;

if ($id <= 0) {
    http_response_code(400);
    echo json_encode(array(
        "status" => "error",
        "message" => "Invalid shipment ID"
    ));
    exit();
}

try {
    $shipment = new Shipment($db);
    $result = $shipment->getById($id);

    if ($result) {
        http_response_code(200);
        echo json_encode(array(
            "status" => "success",
            "data" => $result
        ));
    } else {
        http_response_code(404);
        echo json_encode(array(
            "status" => "error",
            "message" => "Shipment not found"
        ));
    }

} catch (Exception $e) {
    http_response_code(500);
    echo json_encode(array(
        "status" => "error",
        "message" => "Unable to retrieve shipment",
        "error" => $e->getMessage()
    ));
}
?> 