<?php
// Required headers
header("Access-Control-Allow-Origin: *");
header("Content-Type: application/json; charset=UTF-8");
header("Access-Control-Allow-Methods: POST, PUT");
header("Access-Control-Max-Age: 3600");
header("Access-Control-Allow-Headers: Content-Type, Access-Control-Allow-Headers, Authorization, X-Requested-With");

// Include database, auth middleware and shipment model
include_once '../../../config/db.php';
include_once '../../../includes/auth_middleware.php';
include_once '../../../models/Shipment.php';

// Check authentication
AuthMiddleware::isAuthenticated();

// Get database connection
$database = new Database();
$db = $database->getConnection();

// Get posted data
$data = json_decode(file_get_contents("php://input"));

// Check if shipment ID is provided
if (!isset($data->id) || empty($data->id)) {
    http_response_code(400);
    echo json_encode(array(
        "status" => "error",
        "message" => "Shipment ID is required"
    ));
    exit();
}

// Validate that at least one field is being updated
$updatable_fields = [
    'sender_name', 'sender_email', 'sender_phone',
    'receiver_name', 'receiver_email', 'receiver_phone',
    'origin', 'destination', 'payment_type', 'shipping_type',
    'pickup_datetime', 'estimated_delivery_datetime',
    'package_details', 'dimensions', 'weight_kg',
    'value_declared', 'service_type'
];

$has_updates = false;
foreach ($updatable_fields as $field) {
    if (isset($data->$field)) {
        $has_updates = true;
        break;
    }
}

if (!$has_updates) {
    http_response_code(400);
    echo json_encode(array(
        "status" => "error",
        "message" => "No fields to update"
    ));
    exit();
}

try {
    $shipment = new Shipment($db);
    
    // First check if shipment exists
    $existing = $shipment->getById($data->id);
    if (!$existing) {
        http_response_code(404);
        echo json_encode(array(
            "status" => "error",
            "message" => "Shipment not found"
        ));
        exit();
    }

    if ($shipment->update($data->id, $data)) {
        http_response_code(200);
        echo json_encode(array(
            "status" => "success",
            "message" => "Shipment updated successfully"
        ));
    } else {
        http_response_code(500);
        echo json_encode(array(
            "status" => "error",
            "message" => "Unable to update shipment"
        ));
    }

} catch (Exception $e) {
    http_response_code(500);
    echo json_encode(array(
        "status" => "error",
        "message" => "Unable to update shipment",
        "error" => $e->getMessage()
    ));
}
?> 