<?php
// Required headers
header("Access-Control-Allow-Origin: *");
header("Content-Type: application/json; charset=UTF-8");
header("Access-Control-Allow-Methods: GET");
header("Access-Control-Max-Age: 3600");
header("Access-Control-Allow-Headers: Content-Type, Access-Control-Allow-Headers, Authorization, X-Requested-With");

// Include database and auth check
require_once '../../config/database.php';
require_once '../../auth/check_admin_auth.php';
require_once '../../models/Shipment.php';

// Check if user is authenticated
if (!isAdminAuthenticated()) {
    http_response_code(401);
    echo json_encode([
        'status' => 'error',
        'message' => 'Unauthorized access'
    ]);
    exit;
}

try {
    // Get database connection
    $database = new Database();
    $db = $database->getConnection();

    // Create shipment instance
    $shipment = new Shipment($db);
    
    // Get shipments list
    $shipments = $shipment->list();

    if ($shipments) {
        http_response_code(200);
        echo json_encode([
            "status" => "success",
            "shipments" => $shipments
        ]);
    } else {
        http_response_code(200);
        echo json_encode([
            "status" => "success",
            "shipments" => []
        ]);
    }

} catch (Exception $e) {
    http_response_code(500);
    echo json_encode([
        "status" => "error",
        "message" => "Unable to retrieve shipments",
        "error" => $e->getMessage()
    ]);
}
?> 