<?php
require_once '../../config/database.php';
require_once '../../auth/check_admin_auth.php';

header('Content-Type: application/json');

// Check if user is authenticated
if (!isAdminAuthenticated()) {
    http_response_code(401);
    echo json_encode([
        'status' => 'error',
        'message' => 'Unauthorized access'
    ]);
    exit;
}

try {
    $db = new Database();
    $conn = $db->getConnection();

    // Prepare and execute query to get all settings
    $query = "SELECT setting_key, setting_value FROM app_settings";
    $stmt = $conn->prepare($query);
    $stmt->execute();

    // Fetch all settings and convert to associative array
    $settings = [];
    while ($row = $stmt->fetch(PDO::FETCH_ASSOC)) {
        $settings[$row['setting_key']] = $row['setting_value'];
    }

    echo json_encode([
        'status' => 'success',
        'settings' => $settings
    ]);

} catch (PDOException $e) {
    http_response_code(500);
    echo json_encode([
        'status' => 'error',
        'message' => 'Database error: ' . $e->getMessage()
    ]);
} catch (Exception $e) {
    http_response_code(500);
    echo json_encode([
        'status' => 'error',
        'message' => 'Server error: ' . $e->getMessage()
    ]);
} 