<?php
// Required headers
header("Access-Control-Allow-Origin: *");
header("Content-Type: application/json; charset=UTF-8");
header("Access-Control-Allow-Methods: POST");
header("Access-Control-Max-Age: 3600");
header("Access-Control-Allow-Headers: Content-Type, Access-Control-Allow-Headers, Authorization, X-Requested-With");

// Include database and auth middleware
include_once '../../config/db.php';
include_once '../../includes/auth_middleware.php';

// Get posted data
$data = json_decode(file_get_contents("php://input"));

// Validate input
$errors = AuthMiddleware::validateLoginInput($data);
if (!empty($errors)) {
    http_response_code(400);
    echo json_encode(array(
        "status" => "error",
        "message" => "Validation failed",
        "errors" => $errors
    ));
    exit();
}

// Sanitize input
$username = AuthMiddleware::sanitizeInput($data->username);
$password = $data->password;

// Get database connection
$database = new Database();
$db = $database->getConnection();

// Prepare query
$query = "SELECT id, username, password_hash FROM admins WHERE username = ?";
$stmt = $db->prepare($query);
$stmt->execute([$username]);

if ($stmt->rowCount() > 0) {
    $row = $stmt->fetch(PDO::FETCH_ASSOC);
    
    if (password_verify($password, $row['password_hash'])) {
        // Start session and store admin data
        session_start();
        $_SESSION['admin_id'] = $row['id'];
        $_SESSION['username'] = $row['username'];
        
        // Return success response
        http_response_code(200);
        echo json_encode(array(
            "status" => "success",
            "message" => "Login successful",
            "data" => array(
                "admin_id" => $row['id'],
                "username" => $row['username']
            )
        ));
    } else {
        http_response_code(401);
        echo json_encode(array(
            "status" => "error",
            "message" => "Invalid credentials"
        ));
    }
} else {
    http_response_code(401);
    echo json_encode(array(
        "status" => "error",
        "message" => "Invalid credentials"
    ));
}
?> 