<?php
require_once '../../config/database.php';
session_start();

header('Content-Type: application/json');

// Get JSON input
$input = json_decode(file_get_contents('php://input'), true);

// Validate input
if (!isset($input['username']) || !isset($input['password'])) {
    http_response_code(400);
    echo json_encode([
        'status' => 'error',
        'message' => 'Username and password are required'
    ]);
    exit;
}

try {
    $db = new Database();
    $conn = $db->getConnection();

    // Get admin by username, checking both password and password_hash columns
    $stmt = $conn->prepare("
        SELECT id, username, password, password_hash, email, full_name, created_at
        FROM admins 
        WHERE username = ?
    ");
    $stmt->execute([$input['username']]);
    $admin = $stmt->fetch(PDO::FETCH_ASSOC);

    // Verify credentials
    $isValid = false;
    if ($admin) {
        // Try password column first
        if (isset($admin['password']) && password_verify($input['password'], $admin['password'])) {
            $isValid = true;
        }
        // Try password_hash column if password verification failed
        else if (isset($admin['password_hash']) && password_verify($input['password'], $admin['password_hash'])) {
            $isValid = true;
        }
    }

    if (!$isValid) {
        throw new Exception('Invalid username or password');
    }

    // Set session data
    $_SESSION['admin_id'] = $admin['id'];
    $_SESSION['admin_username'] = $admin['username'];
    $_SESSION['admin_email'] = $admin['email'];
    $_SESSION['admin_full_name'] = $admin['full_name'];

    // Remove sensitive data from response
    unset($admin['password']);
    unset($admin['password_hash']);

    echo json_encode([
        'status' => 'success',
        'message' => 'Login successful',
        'admin' => $admin
    ]);

} catch (PDOException $e) {
    http_response_code(500);
    echo json_encode([
        'status' => 'error',
        'message' => 'Database error: ' . $e->getMessage()
    ]);
} catch (Exception $e) {
    http_response_code(401);
    echo json_encode([
        'status' => 'error',
        'message' => $e->getMessage()
    ]);
} 